<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");


        $report_name = "Profit & Loss";

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);
        $s_comp_id = clean_data($_SESSION["comp_id"]);
        if ($comp_id != "All") {
            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
            $comp_detail_one = find_value('company', 'detail_one', " and comp_id = '$s_comp_id'");
        }

        date_default_timezone_set('Asia/Karachi');

        $this->SetFont('Arial', 'B', 30);
        $this->Cell(200, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(200, 10, ($comp_detail_one), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(200, 10, $report_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(5, 10, 'Report printed on : ' . date('d-m-Y h:i:s a'), 0);
        $this->SetFont('Arial', '', 8);
        $this->Cell(188, 10, 'Date: ' . format_date($from_date) .' To ' . format_date($to_date), 0, 0, 'R');

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(100, 8, 'Account', 1);

        $this->Cell(45, 8, 'Amount', 1, 0,'R');
        $this->Cell(45, 8, 'Amount', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);

$l2=find_value('v_system','l2','');
if (empty($l2))
    $l2=6;

/*****************START MYSQL VARIABLES**************/

$comp_name = '';
/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

$tot = 0;
$gp_tot = 0;


$and = '';
$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";
}


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'TURNOVER', 1);
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

try {
    $msqlquery = "SELECT ALL n.acct_name acct_name,
                        SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, $l2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and
                           
                          AND SUBSTR(t.acct_id,1,1)='4'
                        GROUP BY n.acct_name
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY n.acct_id";
//echo $msqlquery;
#        and v.acct_id<>'3010000020'

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$tot=0;
while($report_row = $q_result->fetch(PDO::FETCH_ASSOC))
{
        $tot += $report_row['amt'];
        //$gp_tot += $report_row['amt'];

        $pdf->Cell(1);
        $pdf->Cell(100, 8, $report_row['acct_name'], 1);
        $pdf->Cell(45, 8, format_number_pdf($report_row['amt'],0), 1, 0,'R');
        $pdf->Cell(45, 8, '', 1);

        $pdf->Ln(8);
}

/************************Start Discount*****************************/
try {
    $msqlquery = "SELECT ALL n.acct_id, n.acct_name acct_name,
                        SUM(IFNULL(v.debit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, $l2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and                  
                          AND v.acct_id ='3020000002'
                        GROUP BY n.acct_id, n.acct_name
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY 1";
//echo $msqlquery;
#        and v.acct_id<>'3010000020'

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

while($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $tot -= $report_row['amt'];

    $pdf->Cell(1);
    $pdf->Cell(100, 8, 'Sales Discount', 1);
    $pdf->Cell(45, 8, format_number_pdf($report_row['amt'],0), 1, 0,'R');
    $pdf->Cell(45, 8, '', 1);
    $pdf->Ln(8);
}


/************************End Discount*****************************/



/************************Start Discount*****************************/
try {
    $msqlquery = "SELECT ALL n.acct_id, n.acct_name acct_name,
                        SUM(IFNULL(v.debit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, $l2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and                  
                          AND SUBSTR(t.acct_id,1,1)='4'
                        GROUP BY n.acct_id, n.acct_name
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY 1";
//echo $msqlquery;
#        and v.acct_id<>'3010000020'

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
while($report_row = $q_result->fetch(PDO::FETCH_ASSOC))
{
    $tot -= $report_row['amt'];
    $gp_tot += $tot;


    $pdf->Cell(1);
    $pdf->Cell(100, 8, 'Sales Return', 1);
    $pdf->Cell(45, 8, format_number_pdf($report_row['amt'],0), 1, 0,'R');
    $pdf->Cell(45, 8, '', 1);
    $pdf->Ln(8);
}


/************************End Discount*****************************/



$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(100, 8, '', 1);
$pdf->Cell(45, 8, '', 1);

$pdf->Cell(45, 8, format_number_pdf($tot,0), 1, 0,'R');
$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'COST OF SALES', 1);
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

    try {
        $cgs_query = "SELECT ALL n.acct_name acct_name,
                        SUM(IFNULL(v.debit,0)-IFNULL(v.credit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, $l2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and
                           
                          AND SUBSTR(t.acct_id,1,2)='51'
                        GROUP BY n.acct_name
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY n.acct_id";
    $q_result = $dbcon->prepare($cgs_query);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$tot=0;
while($report_row = $q_result->fetch(PDO::FETCH_ASSOC))
{
    $tot += $report_row['amt'];
    $gp_tot -= $report_row['amt'];

    $pdf->Cell(1);
    $pdf->Cell(100, 8, $report_row['acct_name'], 1);
    $pdf->Cell(45, 8, format_number_pdf($report_row['amt'],0), 1, 0,'R');
    $pdf->Cell(45, 8, '', 1);

    $pdf->Ln(8);
}

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, '', 1);
$pdf->Cell(45, 8, '', 1);
$pdf->Cell(45, 8, format_number_pdf($tot,0), 1, 0,'R');
$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'GROSS PROFIT', 1);
$pdf->Cell(45, 8, '', 1);
$pdf->Cell(45, 8, format_number_pdf($gp_tot,0), 1, 0,'R');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'LESS OPERATING EXPENSES', 1);
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);





try {
    $g1_query = "SELECT  substring(v.acct_id,1,2) acct_id, n.acct_name, count(*)
                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, 2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)

                        WHERE 1=1 $and
                           AND SUBSTR(t.acct_id,1,1)='6'
						GROUP BY substring(v.acct_id,1,2)
                        ORDER BY n.acct_id";
    $g1_result = $dbcon->prepare($g1_query);
    $g1_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$g1_amt_tot = 0;
while($g1_row = $g1_result->fetch(PDO::FETCH_ASSOC)) {
    $g1_acct_id = $g1_row['acct_id'];

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(100, 8, $g1_row['acct_name'], 1);
    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);



    try {
        $exp_query = "SELECT ALL n.acct_name acct_name,
                        SUM(IFNULL(v.debit,0)-IFNULL(v.credit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, 10 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=10) n2 ON (substring(v.acct_id,1,10)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and
                           
                          AND SUBSTR(t.acct_id,1,1)='6'
                          AND SUBSTRING(v.acct_id,1,2)='$g1_acct_id'
                        GROUP BY n.acct_id
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY n.acct_id";
        $q_result = $dbcon->prepare($exp_query);
        $q_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $tot = 0;
    while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
        $tot += $report_row['amt'];
        $gp_tot -= $report_row['amt'];
        $g1_amt_tot +=$report_row['amt'];

        $pdf->Cell(1);
        $pdf->Cell(100, 8, $report_row['acct_name'], 1);
        $pdf->Cell(45, 8, format_number_pdf($report_row['amt'], 0), 1, 0, 'R');
        $pdf->Cell(45, 8, '', 1);

        $pdf->Ln(8);
    }

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(100, 8, $g1_row['acct_name'].' TOTAL', 1, 0,'R');
    $pdf->Cell(45, 8, format_number_pdf($tot,0), 1, 0,'R');
    $pdf->Cell(45, 8, '', 1);
    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);


}

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'OPERATING EXPENSES TOTAL', 1, 0,'R');
$pdf->Cell(45, 8, '', 1);
$pdf->Cell(45, 8, format_number_pdf($g1_amt_tot,0), 1, 0,'R');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'OTHER EXPENSES', 1);
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

try {
    $o_exp_query = "SELECT ALL n.acct_name acct_name,
                        SUM(IFNULL(v.debit,0)-IFNULL(v.credit,0)) amt

                        FROM v_vouchers v
                        LEFT JOIN nom n on substring( v.acct_id, 1, $l2 )=n.acct_id
                        LEFT JOIN (select acct_id, acct_name, acct_type from nom where length(acct_id)=$l2) n2 ON (substring(v.acct_id,1,$l2)=n2.acct_id)
                        LEFT JOIN acct_type t ON (n2.acct_type=t.acct_id)
                        LEFT JOIN company c ON (c.comp_id=v.comp_id)
                        WHERE 1 = 1 $and
                           
                          AND SUBSTR(t.acct_id,1,1)='9'
                        GROUP BY n.acct_id
                        HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0
                        ORDER BY n.acct_id";
    $o_exp_result = $dbcon->prepare($o_exp_query);
    $o_exp_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$tot=0;
while($o_exp_row = $o_exp_result->fetch(PDO::FETCH_ASSOC))
{
    $tot += $o_exp_row['amt'];
    $gp_tot -= $o_exp_row['amt'];

    $pdf->Cell(1);
    $pdf->Cell(100, 8, $o_exp_row['acct_name'], 1);
    $pdf->Cell(45, 8, format_number_pdf($o_exp_row['amt'],0), 1, 0,'R');
    $pdf->Cell(45, 8, '', 1);

    $pdf->Ln(8);
}

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, '', 1);
$pdf->Cell(45, 8, '', 1);
$pdf->Cell(45, 8, format_number_pdf($tot,0), 1, 0,'R');
$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(100, 8, 'PROFIT (LOSS)', 1, 0,'L');
$pdf->Cell(45, 8, '', 1);
$pdf->Cell(45, 8, format_number_pdf($gp_tot,0), 1, 0,'R');

$pdf->Output();
ob_end_flush();